using System;
using System.Collections.Generic;
class Program
{
    static long VektorskiProizvod((long x, long y) o, (long x, long y) a, (long x, long y) b)
    {
        return (a.x - o.x) * (b.y - o.y) - (a.y - o.y) * (b.x - o.x);
    }
    static List<(long x, long y)> Omotac(List<(long x, long y)> tacke)
    {
        tacke.Sort();
        List<(long x, long y)> donje = new List<(long x, long y)>();
        List<(long x, long y)> gornje = new List<(long x, long y)>();
        foreach ((long x, long y) tacka in tacke)
        {
            while (donje.Count >= 2 && VektorskiProizvod(donje[donje.Count - 2], donje[donje.Count - 1], tacka) <= 0)
                donje.RemoveAt(donje.Count - 1);
            donje.Add(tacka);
        }
        for (int i = tacke.Count - 1; i >= 0; i--)
        {
            var point = tacke[i];
            while (gornje.Count >= 2 && VektorskiProizvod(gornje[gornje.Count - 2], gornje[gornje.Count - 1], point) <= 0)
                gornje.RemoveAt(gornje.Count - 1);
            gornje.Add(point);
        }
        donje.RemoveAt(donje.Count - 1);
        gornje.RemoveAt(gornje.Count - 1);
        donje.AddRange(gornje);
        return donje;
    }

    static long PovrsinaMnogougla(List<(long x, long y)> m)
    {
        long p = 0;
        for (int i = 0; i < m.Count; i++)
            p += m[i].x * (m[(i + 1) % m.Count].y) - m[i].y * (m[(i + 1) % m.Count].x);
        return Math.Abs(p) / 2;
    }
    static long SkoroOmotac(List<(long x, long y)> tacke)
    {
        var omotac = Omotac(tacke);
        long min = long.MaxValue;
        foreach (var tacka in omotac)
        {
            List<(long x, long y)> ostaleTacke = new List<(long x, long y)>();
            foreach (var t in tacke)
                if (t != tacka) ostaleTacke.Add(t);
            List<(long x, long y)> omotacT = Omotac(ostaleTacke);
            long p = PovrsinaMnogougla(omotacT);
            min = Math.Min(min, p);
        }
        return min;
    }
    static void Main(string[] args)
    {
        int n = int.Parse(Console.ReadLine());
        List<(long x, long y)> t = new List<(long x, long y)>();
        for (int i = 0; i < n; i++)
        {
            string[] s = Console.ReadLine().Split();
            t.Add((long.Parse(s[0]), long.Parse(s[1])));
        }
        Console.WriteLine(SkoroOmotac(t));
    }
}